//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Threading;

namespace ProfilingSamples
{
	public class GCLargeObjectMain 
	{
		private ManualResetEvent asyncEvent;
		void LargeThread()
		{
			byte [] ba = new byte[10000000];
			for(int i = 0; i < ba.Length; i++)
			{
				ba[i] = (byte)(i % 256);
			}
			asyncEvent.WaitOne();
			ba = null;
		}
		void TestThread()
		{
			Thread t;
			asyncEvent = new ManualResetEvent(false);
			try
			{
				while(true)
				{
					asyncEvent.Reset();
					t = new Thread(new ThreadStart(LargeThread));
					t.Start();

					Thread.Sleep(500);

					// Wykonanie GC zmienia generacj obiektu
					GC.Collect();

					asyncEvent.Set();
					t.Join();

					Thread.Sleep(500);
					// Wykonanie GC zmienia generacj obiektu
					GC.Collect();

					Thread.Sleep(500);
				}
			}
			catch(Exception e)
			{
				Console.WriteLine("TestThread przerywa prac: {0}", e.Message);
			}
		}
		static void Main(string [] args)
		{
			GCLargeObjectMain m = new GCLargeObjectMain();
			Thread testThread = new Thread(new ThreadStart(m.TestThread));
			testThread.Start();
			string input = Console.ReadLine();
			testThread.Abort();
			testThread.Join();
		}
	}
}